;****************************************************************************************
;*                           UHF-FUCHS-NF-STEUERUNG VON DL3UKH                          *
;*                           =================================                          *
;*                                                                                      *
;*                       ES KOMMT EIN NF-TON 800HZ IM MORSETAKT RAUS                    *
;*                       ES WIRD "MO" UND EIN ZEICHEN A-Z UND 0-9 USW. FOLGEND          *
;*                       WHLBAR AUSGEGEBEN. MAN KANN MIT 6STCK.DIL-SCHALTERN           *
;*                       EINSTELLEN.                                                    *
;*                       MAN KANN DAS TEMPO 30/60ZPM MIT EINEM PIN WHLEN               *
;*                       MAN KANN AUCH ZWISCHEN MORSEN UND DAUERTON (800HZ) WHLEN      *
;*                                                                                      *
;*--------------------------------------------------------------------------------------*
;*                           NF-AUSGANG       PIN   RA1    AUSGANG                      *
;*                           TEMPO 30/60ZPM   PIN   RB6    EINGANG 60/LOW   30/HIGH     *
;*      ZEICHENEINSTELLUNG   A-Z UND 0-9 USW. PIN'S RB0-5  EINGANG                      *
;*                           MORSEN/LIED      PIN   RB7    EINGANG                      *
;*--------------------------------------------------------------------------------------*
;*                           FREQUENZEN:                                                *
;*                                       433,000-435,000MHZ ALLE BETRIEBSARTEN  HIER    *
;*                                       GEWHLT: 433.150 + 433.200MHZ                  *
;*                                                                                      *
;*--------------------------------------------------------------------------------------*
;*                           BEGINN: 27.05.04                                           *
;*                           ENDE  : 28.05.04                                           *
;*                         GETESTET: 28.05.04   ALS UHF_FU05.ASM                        *
;*                                                                                      *
;*                                                                                      *
;*                           ES KLAPPERT DIE MUEHLE AM RAUSCHENDEN BACH                 *
;*                                                                                      *
;*                                                                                      *
;*                                                                                      *
;****************************************************************************************

	LIST  	P=16F84	
	TITLE	"UHF-FUCHSJAGD-TX"

	ERRORLEVEL -302
	INCLUDE	<P16F84.INC>
__CONFIG  _XT_OSC & _WDT_OFF & _PWRTE_OFF & _CP_OFF
;ALS PIC-IC WURDE GENOMMEN PIC16F84-04/P

;BEIM PROGRAMMIEREN:
;WATCHDOG MU AUF OFF STEHEN UND PROTECTED MU AUCH AUF OFF STEHEN
;ALSO ALLES AUF OFF AUCH UP TIME AUF OFF UND XT ALS OSZILLATOR

;-OSZILLATOR IST EIN QUARZ MIT 2MHZ.  (T=0.5S)

	ORG 0DH 

ZPM	RES	1		;FR TEMPO 30/60
COD	RES	1		;FR MORSE-CODE
ANZ	RES	1		;FR MORSE-ZEICHEN-ANZAHL
MERK	RES	1		;NORMALER ZWISCHENSPEICHER
ZAE	RES	1		;FUER TONFREQUENZ 800HZ
ENDTON	RES	1		;ENDE TON-LAENGEN-ERKENNUNG

;---------------------------------------------------------------------------------
;VARIABLEN
BIT0		EQU	0
BIT1		EQU	1
BIT2		EQU	2
BIT3		EQU	3
BIT4		EQU	4
BIT5		EQU	5
BIT6		EQU	6
BIT7		EQU	7



;SPEICHERANFANG BZW. BEGINN

	ORG 0X0000
	GOTO MAIN		; SPRUNG ZUM HAUPTPROGRAMM


	ORG 0X0010
;*****************************************************************************
;*                            TIMER 0  INIT  FUERS MORSEN                    *
;*                              13.05.04                                     *
;*****************************************************************************
ITIM	MOVLW	D'98'
	MOVWF	TMR0
	BCF	INTCON, T0IF	;OVERFLOW = 0
	RETURN
;ZEITBERECHNUNG 81MS=TEMPO 60ZPM
;PRESCALER 256X  +  SYSTEM 4X  ====> 256*4*0.5S=512S
;512S*D'158'=81MS
;TMR0 ALSO D'256'-D'158'=D'98' ENTSPRICHT CA. 81MS
;BEI TEMPO 30ZPM =162MS ALSO 2* DURCHLAUFEN
;*****************************************************************************
;*                            TIMER 0  INIT  FUER PAUSE LIED                 *
;*                              13.05.04                                     *
;*****************************************************************************
PTIM	MOVLW	D'236'
	MOVWF	TMR0
	BCF	INTCON, T0IF	;OVERFLOW = 0
	RETURN

;ZEITBERECHNUNG 10MS=GESCHAETZT FUER TONLAENGE
;PRESCALER 256X  +  SYSTEM 4X  ====> 256*4*0.5S=512S
;512S*D'20'=10.24MS
;TMR0 ALSO D'256'-D'20'=D'236' ENTSPRICHT CA. 10MS
;*****************************************************************************
;*                            TIMER 0  INIT  FUER LIED LAENGE                *
;*                              13.05.04                                     *
;*****************************************************************************
LTIM	MOVLW	D'236'
	MOVWF	TMR0
	BCF	INTCON, T0IF	;OVERFLOW = 0

	DECFSZ	ANZ, F		;TONLAENGEN-DURCHLAEUFE
	GOTO	LTIM1
	MOVLW	D'1'
	MOVWF	ENDTON	

LTIM1	RETURN

;ZEITBERECHNUNG 10MS=GESCHAETZT FUER TONLAENGE
;PRESCALER 256X  +  SYSTEM 4X  ====> 256*4*0.5S=512S
;512S*D'20'=10.24MS
;TMR0 ALSO D'256'-D'20'=D'236' ENTSPRICHT CA. 10MS
;*****************************************************************************
;*                            DAUER-PAUSE                                    *
;*                              24.05.04                                     *
;*****************************************************************************
DPAUSE	MOVLW 	D'7'		;ZEITSCHLEIFE 7X PAUSE 
	MOVWF 	MERK
LLOOP	CALL 	PAUSE
	DECFSZ 	MERK,F
	GOTO 	LLOOP
	RETURN
;*****************************************************************************
;*                              PAUSE                                        *
;*                              24.02.04                                     *
;*****************************************************************************
PAUSE	BTFSS	PORTB, BIT6
	GOTO	PA0

	MOVLW	D'1'		;TEMPO 60 BEI LOW
	MOVWF	ZPM
	GOTO	PWEIT

PA0	MOVLW	D'2'		;TEMPO 30 BEI HIGH
	MOVWF	ZPM

PWEIT	CALL	ITIM

PSS1	BTFSC	INTCON, T0IF	
	GOTO	PSS0
	GOTO	PSS1

PSS0	DECFSZ	ZPM
	GOTO	PWEIT

	RETURN
;*****************************************************************************
;*                            PUNKT MIT TON                                  *
;*                              24.02.04                                     *
;*****************************************************************************
PUNKT	BTFSS	PORTB, BIT6
	GOTO	TA0

	MOVLW	D'1'		;TEMPO 60 BEI LOW
	MOVWF	ZPM
	GOTO	TWEIT

TA0	MOVLW	D'2'		;TEMPO 30 BEI HIGH
	MOVWF	ZPM

TWEIT	CALL	ITIM

;-------------------------------------------------------------------------------------------
;--------------- 1 / 800HZ = 1.25MS  /2 =625S --> ALSO 625S EINE HALBWELLE ---------------
;-------------------------------------------------------------------------------------------
TON0	MOVLW	D'62'
	MOVWF	ZAE
	BSF	PORTA, BIT1	;NF EIN
	
TS1	BTFSC	INTCON, T0IF				;8T
	GOTO	TS0
	DECFSZ	ZAE, F					;4T
	GOTO	TS1					;8T GESAMT:20T*0.5S=10S  ALSO 10*62=620S

	MOVLW	D'62'
	MOVWF	ZAE
	BCF	PORTA, BIT1	;NF AUS
	
TS2	BTFSC	INTCON, T0IF				;8T
	GOTO	TS01
	DECFSZ	ZAE, F					;4T
	GOTO	TS2					;8T
	GOTO	TON0

TS0	DECFSZ	ZPM
	GOTO	TINI1
	GOTO	TEND
TINI1	CALL	ITIM
	GOTO	TS1

TS01	DECFSZ	ZPM
	GOTO	TINI2
	GOTO	TEND
TINI2	CALL	ITIM
	GOTO	TS2

TEND	BCF	PORTA, BIT1	;NF AUS
	RETURN
;*****************************************************************************
;*                           STRICH MIT TON                                  *
;*                              24.02.04                                     *
;*****************************************************************************
STRICH	BTFSS	PORTB, BIT6
	GOTO	SA0

	MOVLW	D'3'		;TEMPO 60 BEI LOW
	MOVWF	ZPM
	GOTO	SWEIT

SA0	MOVLW	D'6'		;TEMPO 30 BEI HIGH
	MOVWF	ZPM

SWEIT	CALL	ITIM
;-------------------------------------------------------------------------------------------
;--------------- 1 / 800HZ = 1.25MS  /2 =625S --> ALSO 625S EINE HALBWELLE ---------------
;-------------------------------------------------------------------------------------------
STON0	MOVLW	D'62'
	MOVWF	ZAE
	BSF	PORTA, BIT1	;NF EIN
	
STS1	BTFSC	INTCON, T0IF				;8T
	GOTO	STS0
	DECFSZ	ZAE, F					;4T
	GOTO	STS1					;8T GESAMT:20T*0.5S=10S  ALSO 10*62=620S

	MOVLW	D'62'
	MOVWF	ZAE
	BCF	PORTA, BIT1	;NF AUS
	
STS2	BTFSC	INTCON, T0IF				;8T
	GOTO	STS01
	DECFSZ	ZAE, F					;4T
	GOTO	STS2					;8T
	GOTO	STON0

STS0	DECFSZ	ZPM
	GOTO	STINI1
	GOTO	STEND
STINI1	CALL	ITIM
	GOTO	STS1

STS01	DECFSZ	ZPM
	GOTO	STINI2
	GOTO	STEND
STINI2	CALL	ITIM
	GOTO	STS2

STEND	BCF	PORTA, BIT1	;NF AUS
	RETURN
;*****************************************************************************
;*                       MORSE-PUNKT-STRICH-CODE                             *
;*                              20.12.98                                     *
;*****************************************************************************
MCOD	MOVF 	PORTB,W		; LESE PORT B
	ANDLW 	0X3F		; NUR BIT0-5 AUSWERTEN
	ADDWF 	PCL,F		; AUF STELLE DES ZU LESENDEN BYTES BRINGEN  ??
				; JE NACH DIL-SCHALTER-STELLUNG (INHALT VON W)


;JETZT KOMMT DER PUNKT[0]-STRICH[1]-CODE FR ALLE DEUTSCHEN MORSEZEICHEN
;BIT7 IST DAS ERSTE STR/PKT-ZEICHEN
;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------

	RETLW B'01000000'	;A 2 DIE ZAHL IST DIE ANZAHL
	RETLW B'10000000'	;B 4
	RETLW B'10100000'	;C 4
	RETLW B'10000000'	;D 3
	RETLW B'00000000'	;E 1
	RETLW B'01000000'	;F 4
	RETLW B'11000000'	;G 3
	RETLW B'00000000'	;H 4
	RETLW B'00000000'	;I 2
	RETLW B'01110000'	;J 4
	RETLW B'10100000'	;K 3
	RETLW B'01000000'	;L 4
	RETLW B'11000000'	;M 2
	RETLW B'10000000'	;N 2
	RETLW B'11100000'	;O 3
	RETLW B'01100000'	;P 4
	RETLW B'11010000'	;Q 4
	RETLW B'01000000'	;R 3
	RETLW B'00000000'	;S 3
	RETLW B'10000000'	;T 1
	RETLW B'00100000'	;U 3
	RETLW B'00010000'	;V 4
	RETLW B'01100000'	;W 3
	RETLW B'10010000'	;X 4
	RETLW B'10110000'	;Y 4
	RETLW B'11000000'	;Z 4
	RETLW B'11111000'	;0 5
	RETLW B'01111000'	;1 5
	RETLW B'00111000'	;2 5
	RETLW B'00011000'	;3 5
	RETLW B'00001000'	;4 5
	RETLW B'00000000'	;5 5
	RETLW B'10000000'	;6 5
	RETLW B'11000000'	;7 5
	RETLW B'11100000'	;8 5
	RETLW B'11110000'	;9 5
	RETLW B'00110000'	;? 6
	RETLW B'11001100'	;, 6
	RETLW B'10010000'	;/ 5
	RETLW B'01010100'	;. 6
	RETLW B'10001000'	;= 5
;*****************************************************************************
;*                       MORSE-PUNKT-STRICH-ANZAHL                           *
;*                              20.12.98                                     *
;*****************************************************************************
MANZ	MOVF 	PORTB,W		; LESE PORT B
	ANDLW 	0X3F		; NUR BIT0-5 AUSWERTEN
	ADDWF 	PCL,F		; AUF STELLE DES ZU LESENDEN BYTES BRINGEN  ??
				; JE NACH DIL-SCHALTER-STELLUNG (INHALT VON W)

;JETZT KOMMT ANZAHL DER STRICHE/PUNKTE FR ALLE DEUTSCHEN MORSEZEICHEN

	RETLW D'2'	;A 2  0 BYTEAUSWAHLKONTROLLE   DIE ZAHL IST DIE ANZAHL
	RETLW D'4'	;B 4  1
	RETLW D'4'	;C 4  2
	RETLW D'3'	;D 3  3
	RETLW D'1'	;E 1  4
	RETLW D'4'	;F 4  5
	RETLW D'3'	;G 3  6
	RETLW D'4'	;H 4  7
	RETLW D'2'	;I 2  8
	RETLW D'4'	;J 4  9 
	RETLW D'3'	;K 3  10
	RETLW D'4'	;L 4  11
	RETLW D'2'	;M 2  12
	RETLW D'2'	;N 2  13
	RETLW D'3'	;O 3  14
	RETLW D'4'	;P 4  15
	RETLW D'4'	;Q 4  16
	RETLW D'3'	;R 3  17
	RETLW D'3'	;S 3  18
	RETLW D'1'	;T 1  19
	RETLW D'3'	;U 3  20
	RETLW D'4'	;V 4  21
	RETLW D'3'	;W 3  22
	RETLW D'4'	;X 4  23
	RETLW D'4'	;Y 4  24
	RETLW D'4'	;Z 4  25
	RETLW D'5'	;0 5  26
	RETLW D'5'	;1 5  27
	RETLW D'5'	;2 5  28
	RETLW D'5'	;3 5  29
	RETLW D'5'	;4 5  30
	RETLW D'5'	;5 5  31
	RETLW D'5'	;6 5  32
	RETLW D'5'	;7 5  33
	RETLW D'5'	;8 5  34 
	RETLW D'5'	;9 5  35
	RETLW D'6'	;? 6  36
	RETLW D'6'	;, 6  37
	RETLW D'5'	;/ 5  38
	RETLW D'6'	;. 6  39
	RETLW D'5'	;= 5  40     40====> 0X28 ==> 0X00101000  ==> ALSO 6BIT AUSWERTEN
;*****************************************************************************
;*                       MORSE-ZEICHEN ALS ASCII                             *
;*                              20.12.98                                     *
;*****************************************************************************
;ACOD	MOVF 	PORTB,W		; LESE PORT B
;	ANDLW 	0X3F		; NUR BIT0-5 AUSWERTEN
;	ADDWF 	PCL,F		; AUF STELLE DES ZU LESENDEN BYTES BRINGEN  ??
				; JE NACH DIL-SCHALTER-STELLUNG (INHALT VON W)

;JETZT KOMMT DAS ASCII-ZEICHEN FR ALLE DEUTSCHEN MORSEZEICHEN

;	RETLW 'A'	;A 2 DIE ZAHL IST DIE ANZAHL
;	RETLW 'B'	;B 4
;	RETLW 'C'	;C 4
;	RETLW 'D'	;D 3
;	RETLW 'E'	;E 1
;	RETLW 'F'	;F 4
;	RETLW 'G'	;G 3
;	RETLW 'H'	;H 4
;	RETLW 'I'	;I 2
;	RETLW 'J'	;J 4
;	RETLW 'K'	;K 3
;	RETLW 'L'	;L 4
;	RETLW 'M'	;M 2
;	RETLW 'N'	;N 2
;	RETLW 'O'	;O 3
;	RETLW 'P'	;P 4
;	RETLW 'Q'	;Q 4
;	RETLW 'R'	;R 3
;	RETLW 'S'	;S 3
;	RETLW 'T'	;T 1
;	RETLW 'U'	;U 3
;	RETLW 'V'	;V 4
;	RETLW 'W'	;W 3
;	RETLW 'X'	;X 4
;	RETLW 'Y'	;Y 4
;	RETLW 'Z'	;Z 4
;	RETLW '0'	;0 5
;	RETLW '1'	;1 5
;	RETLW '2'	;2 5
;	RETLW '3'	;3 5
;	RETLW '4'	;4 5
;	RETLW '5'	;5 5
;	RETLW '6'	;6 5
;	RETLW '7'	;7 5
;	RETLW '8'	;8 5
;	RETLW '9'	;9 5
;	RETLW '?'	;? 6
;	RETLW ','	;, 6
;	RETLW '/'	;/ 5
;	RETLW '.'	;. 6
;	RETLW '='	;= 5
;*****************************************************************************
;*                            HAUPTPROGRAMM                                  *
;*                              23.02.04                                     *
;*****************************************************************************
MAIN	BCF	STATUS, RP0	;BANK0
	BCF	STATUS, RP1

	MOVLW 	0X00 		;INIT I/O PORT A ALLES AUSGAENGE
	BSF	STATUS, RP0	;BANK1
	MOVWF	TRISA
	BCF	STATUS, RP0	;BANK0
	MOVLW 	0XFF		;INIT I/O PORT B ALLES EINGAENGE
	BSF	STATUS, RP0	;BANK1
	MOVWF	TRISB
	BCF	STATUS, RP0	;BANK0

	BSF	STATUS, RP0	;BANK1
	MOVLW	B'00000111'	;BIT0-2 1=PRESCALER256, BIT3 0=TMR0, BIT4 0=ENTFAELLT, BIT5 0=TAKT VOM SYSTEM, BIT6 0=KEIN RB-INTERRUPT, BIT7 0=PULL-UPS ENABLE 
	MOVWF	OPTION_REG	
	BCF	STATUS, RP0	;BANK0

	MOVLW	0X00		;PORTA ALLES AUF LOW
	MOVWF	PORTA

;ES GEHT LOS

MO	BTFSC	PORTB, BIT7
	GOTO	MO0		;ES GEHT ZUM MORSEN


;-------------------------------------------------------------------------------------------

HLIED0	MOVLW	D'0'
	MOVWF	MERK		;ZAEHLER FR NOTENFOLGE
HLIED2	CALL	LIED
	MOVWF	COD		;TONHOEHE
	MOVLW 	H'00'		;ADRESSE SPEICHERN NEUES PCLATH
	MOVWF 	PCLATH

	CALL	LAENGE
	MOVWF	ANZ		;LAENGE
	MOVLW 	H'00'		;ADRESSE SPEICHERN NEUES PCLATH
	MOVWF 	PCLATH

	MOVLW	0XFF		;BEI COD=0XFF IST ES DAS ENDE DES LIEDES
	SUBWF	COD, W		
	BTFSC	STATUS, Z
	GOTO	HLIED0	

HLIED6	MOVLW	D'0'		;BEI COD=0 IST ES EINE PAUSE OHNE TON
	SUBWF	COD, W		
	BTFSS	STATUS, Z
	GOTO	HLIED8

HLIED5	CALL	PTIM
HLIED4	BTFSS	INTCON, T0IF
	GOTO 	HLIED4
	DECFSZ	ANZ, F		;PAUSENLAENGE IMMER 1 WENIGER
	GOTO	HLIED5
	GOTO	HLIED3

HLIED8	CALL	PTIM
	MOVLW	D'0'
	MOVWF	ENDTON

HLIED1	MOVF	COD, W
	MOVWF	ZAE
	BSF	PORTA, BIT1	;NF EIN
		
HS1	NOP						;4T
	NOP						;4T
	DECFSZ	ZAE, F					;4T
	GOTO	HS1					;8T GESAMT:20T*0.5S=10S  ALSO 10*62=620S

	BTFSC	INTCON, T0IF				
	CALL	LTIM

	MOVLW	D'1'		
	SUBWF	ENDTON, W		
	BTFSC	STATUS, Z
	GOTO	HLIED3

	MOVF	COD, W
	MOVWF	ZAE
	BCF	PORTA, BIT1	;NF AUS
	
HS2	NOP						;4T
	NOP						;4T
	DECFSZ	ZAE, F					;4T
	GOTO	HS2					;8T

	BTFSC	INTCON, T0IF				
	CALL	LTIM

	MOVLW	D'1'		
	SUBWF	ENDTON, W		
	BTFSS	STATUS, Z
	GOTO	HLIED1

HLIED3	MOVLW	D'2'		;KONSTANTE PAUSE ZWISCHEN DEN NOTEN   20MS
	MOVWF	ANZ

HH2	CALL	PTIM
HH1	BTFSS	INTCON, T0IF
	GOTO 	HH1
	DECFSZ	ANZ, F		;PAUSENLAENGE IMMER 1 WENIGER
	GOTO	HH2

	INCF	MERK, F

	BTFSS	PORTB, BIT7
	GOTO	HLIED2
;-------------------------------------------------------------------------------------------
;------- MORSEN VON ZEICHEN, BEGINNEND MIT MO, DANN BELIEBIGES ZEICHEN (A-Z 0-9 .,/=?) -----
;-------------------------------------------------------------------------------------------

MO0	CALL 	STRICH		;DAS "M"
	CALL 	PAUSE		;ZWISCHENRAUM
	CALL 	STRICH
	CALL 	PAUSE		;ZWISCHENRAUM
	CALL 	PAUSE
	CALL 	PAUSE
	CALL	PAUSE

	CALL 	STRICH		;DAS "O"
	CALL 	PAUSE
	CALL 	STRICH
	CALL 	PAUSE
	CALL 	STRICH
	CALL 	PAUSE		;ZWISCHENRAUM
	CALL 	PAUSE
	CALL 	PAUSE
	CALL	PAUSE

	CALL 	MCOD		;MORSE-CODE LESEN
	MOVWF 	COD		;ZWISCHEN-SPEICHERN IN COD
	CALL 	MANZ		;MORSE-ANZAHL LESEN
	MOVWF 	ANZ		;ZWISCHEN-SPEICHERN IN ANZ

	MOVLW 	0X80		;ZWISCHENSPEICHERN VON MASKE PUNKT/STRICH
	MOVWF 	MERK

ZEI	MOVF 	MERK,W		;DAS FOLGE-ZEICHEN
	ANDWF 	COD,W
	BTFSC	STATUS,Z	;SPRUNG BEI Z==1 (PUNKT) ALSO 001100 IST ..--..
	GOTO 	PUNK

	CALL	STRICH
	CALL 	PAUSE
	GOTO 	RR

PUNK	CALL 	PUNKT
	CALL 	PAUSE

RR	BCF 	STATUS, C	
	RRF 	MERK,F		;MERK WIRD ZU 40H ALSO ANDERE MASKE 
	DECFSZ 	ANZ,F		;ZEICHENANZAHL DECRIMENTIEREN, WENN 0 ==> PC+2 SPRUNG
	GOTO 	ZEI

	CALL	DPAUSE		;ZEITSCHLEIFE 7X PAUSE //NACH ENDE DES DAUERTONES(ZWITSCHERN)

	GOTO 	MO

	ORG 0200H
;*****************************************************************************
;*                             TON-HOEHE                                     *
;*                              27.05.04                                     *
;*                                                                           *
;*                           ES KLAPPERT DIE MUEHLE AM RAUSCHENDEN BACH      *
;*                                                                           *
;*****************************************************************************
LIED	MOVLW H'02'		;ADRESSE SPEICHERN NEUES PCLATH
	MOVWF PCLATH

	MOVF 	MERK,W		; ZAEHLER DER TONHOEHE
	ADDWF 	PCL,F		; AUF STELLE DES ZU LESENDEN BYTES BRINGEN  ??


	RETLW D'191'	;C
	RETLW D'191'	;C
	RETLW D'191'	;C
	RETLW D'191'	;C
	RETLW D'191'	;C
	RETLW D'170'	;D
	RETLW D'152'	;E
	RETLW D'152'	;E
	RETLW D'170'	;D
	RETLW D'170'	;D
	RETLW D'170'	;D
	RETLW D'0'	;PAUSE
	RETLW D'128'	;G
	RETLW D'152'	;E
	RETLW D'0'	;PAUSE
	RETLW D'191'	;C 1

	RETLW D'191'	;C
	RETLW D'191'	;C
	RETLW D'191'	;C
	RETLW D'191'	;C
	RETLW D'170'	;D
	RETLW D'152'	;E
	RETLW D'152'	;E
	RETLW D'170'	;D
	RETLW D'170'	;D
	RETLW D'170'	;D
	RETLW D'0'	;PAUSE
	RETLW D'128'	;G
	RETLW D'152'	;E
	RETLW D'0'	;PAUSE
	RETLW D'191'	;C
	RETLW D'128'	;G
	RETLW D'128'	;G
	RETLW D'128'	;G
	RETLW D'128'	;G
	RETLW D'114'	;A
	RETLW D'128'	;G 2

	RETLW D'128'	;G
	RETLW D'143'	;F
	RETLW D'143'	;F
	RETLW D'143'	;F
	RETLW D'143'	;F
	RETLW D'152'	;E
	RETLW D'152'	;E
	RETLW D'152'	;E
	RETLW D'128'	;G
	RETLW D'143'	;F
	RETLW D'152'	;E
	RETLW D'152'	;E
	RETLW D'170'	;D
	RETLW D'170'	;D
	RETLW D'170'	;D
	RETLW D'128'	;G
	RETLW D'152'	;E
	RETLW D'0'	;PAUSE
	RETLW D'152'	;E
	RETLW D'170'	;D
	RETLW D'0'	;PAUSE
	RETLW D'170'	;D
	RETLW D'191'	;C


	RETLW D'0'	;PAUSE
	RETLW 0XFF	;ENDE

;*****************************************************************************
;*                             TON-HOEHEN-BESCHREIBUNG                       *
;*                              28.05.04                                     *
;*****************************************************************************
;
;
;TIEFE OKTAVE
;	RETLW D'254'	;G
;	RETLW D'240'	;GIS
;	RETLW D'227'	;A
;	RETLW D'214'	;AIS
;	RETLW D'202'	;H
;
;NORMALE OKTAVE
;	RETLW D'191'	;C
;	RETLW D'180'	;CIS
;	RETLW D'170'	;D
;	RETLW D'160'	;DIS
;	RETLW D'152'	;E
;	RETLW D'143'	;F
;	RETLW D'135'	;FIS
;	RETLW D'128'	;G
;	RETLW D'120'	;GIS
;	RETLW D'114'	;A
;	RETLW D'107'	;AIS
;	RETLW D'101'	;H
;
;HOHE OKTAVE
;	RETLW D'96'	;C
;	RETLW D'90'	;CIS
;	RETLW D'85'	;D
;	RETLW D'80'	;DIS
;	RETLW D'76'	;E
;	RETLW D'72'	;F
;	RETLW D'68'	;FIS
;	RETLW D'64'	;G
;	RETLW D'60'	;GIS
;	RETLW D'57'	;A
;	RETLW D'54'	;AIS
;	RETLW D'51'	;H
;

	ORG 0300H
;*****************************************************************************
;*                             TON-LAENGE                                    *
;*                              27.05.04                                     *
;*****************************************************************************
LAENGE	MOVLW H'03'		;ADRESSE SPEICHERN NEUES PCLATH
	MOVWF PCLATH

	MOVF 	MERK,W		; ZAEHLER DER LAENGE
	ADDWF 	PCL,F		; AUF STELLE DES ZU LESENDEN BYTES BRINGEN  ??


	RETLW D'23'	;C
	RETLW D'23'	;C
	RETLW D'23'	;C
	RETLW D'23'	;C
	RETLW D'23'	;C
	RETLW D'23'	;D
	RETLW D'23'	;E 1

	RETLW D'23'	;E
	RETLW D'23'	;D
	RETLW D'23'	;D
	RETLW D'23'	;D
	RETLW D'23'	;PAUSE
	RETLW D'23'	;G
	RETLW D'23'	;E
	RETLW D'92'	;PAUSE
	RETLW D'23'	;C 2

	RETLW D'23'	;C
	RETLW D'23'	;C
	RETLW D'23'	;C
	RETLW D'23'	;C
	RETLW D'23'	;D
	RETLW D'23'	;E
	RETLW D'23'	;E
	RETLW D'23'	;D
	RETLW D'23'	;D
	RETLW D'23'	;D
	RETLW D'23'	;PAUSE
	RETLW D'23'	;G 3

	RETLW D'23'	;E
	RETLW D'92'	;PAUSE
	RETLW D'23'	;C
	RETLW D'23'	;G
	RETLW D'23'	;G
	RETLW D'23'	;G
	RETLW D'23'	;G
	RETLW D'23'	;A
	RETLW D'23'	;G 4

	RETLW D'23'	;G
	RETLW D'23'	;F
	RETLW D'23'	;F
	RETLW D'46'	;F
	RETLW D'23'	;F
	RETLW D'23'	;E
	RETLW D'23'	;E
	RETLW D'23'	;E
	RETLW D'23'	;G
	RETLW D'23'	;F
	RETLW D'23'	;E 5

	RETLW D'23'	;E
	RETLW D'23'	;D
	RETLW D'23'	;D
	RETLW D'46'	;D
	RETLW D'23'	;G
	RETLW D'23'	;E
	RETLW D'23'	;PAUSE
	RETLW D'23'	;E
	RETLW D'23'	;D
	RETLW D'23'	;PAUSE
	RETLW D'23'	;D
	RETLW D'23'	;C 6

	RETLW D'254'	;PAUSE
	RETLW 0XFF	;ENDE


	END

;*****************************************************************************
;*                             TON-LAENGEN-BESCHREIBUNG                      *
;*                              28.05.04                                     *
;*****************************************************************************
;
;
;	RETLW D'11'	;110MS  1/16 NOTENLAENGE
;	RETLW D'23'	;230MS  1/8 NOTENLAENGE
;	RETLW D'46'	;460MS  1/4 NOTENLAENGE
;	RETLW D'92'	;920MS  1/2 NOTENLAENGE
;	RETLW D'xxx'	;xxxMS  1 NOTENLAENGE
;
;

